<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "asistencia".
 *
 * @property int $id
 * @property int $personal_id
 * @property int $unidad_id
 * @property string|null $entrada
 * @property string|null $horaentrada
 * @property string|null $salida
 * @property string|null $horasalida
 * @property float|null $horas
 * @property int|null $estado
 *
 * @property Personal $personal
 * @property Unidad $unidad
 */
class Asistencia extends \yii\db\ActiveRecord
{

    public $personalnombre;
    public $unidadnombre;
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'asistencia';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['personal_id', 'unidad_id'], 'required'],
            [['personal_id', 'unidad_id', 'estado'], 'integer'],
            [['entrada', 'horaentrada', 'salida', 'horasalida'], 'safe'],
            [['horas'], 'number'],
            [['personal_id'], 'exist', 'skipOnError' => true, 'targetClass' => Personal::className(), 'targetAttribute' => ['personal_id' => 'id']],
            [['unidad_id'], 'exist', 'skipOnError' => true, 'targetClass' => Unidad::className(), 'targetAttribute' => ['unidad_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'personal_id' => 'Personal',
            'unidad_id' => 'Unidad',
            'entrada' => 'Entrada',
            'horaentrada' => 'Hora Entrada',
            'salida' => 'Salida',
            'horasalida' => 'Hora Salida',
            'horas' => 'Horas',
            'estado' => 'Estado',
        ];
    }

    /**
     * Gets query for [[Personal]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPersonal()
    {
        return $this->hasOne(Personal::className(), ['id' => 'personal_id']);
    }

    /**
     * Gets query for [[Unidad]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUnidad()
    {
        return $this->hasOne(Unidad::className(), ['id' => 'unidad_id']);
    }
}
