<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "horario".
 *
 * @property int $id
 * @property int $personal_id
 * @property int $unidad_id
 * @property string|null $fechaini
 * @property string|null $horaentrada
 * @property string|null $fechafin
 * @property string|null $horasalida
 * @property string|null $tipoturno
 * @property int|null $sit
 *
 * @property Personal $personal
 * @property Unidad $unidad
 */
class Horario extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'horario';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['personal_id', 'unidad_id'], 'required'],
            [['personal_id', 'unidad_id', 'sit'], 'integer'],
            [['fechaini', 'horaentrada', 'fechafin', 'horasalida'], 'safe'],
            [['tipoturno'], 'string', 'max' => 45],
            [['personal_id'], 'exist', 'skipOnError' => true, 'targetClass' => Personal::className(), 'targetAttribute' => ['personal_id' => 'id']],
            [['unidad_id'], 'exist', 'skipOnError' => true, 'targetClass' => Unidad::className(), 'targetAttribute' => ['unidad_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'personal_id' => 'Personal',
            'unidad_id' => 'Unidad',
            'fechaini' => 'Fecha Entrada',
            'horaentrada' => 'Hora Entrada',
            'fechafin' => 'Fecha Salida',
            'horasalida' => 'Hora Salida',
            'tipoturno' => 'Tipo Turno',
            'sit' => 'Sit',
        ];
    }

    /**
     * Gets query for [[Personal]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPersonal()
    {
        return $this->hasOne(Personal::className(), ['id' => 'personal_id']);
    }

    /**
     * Gets query for [[Unidad]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUnidad()
    {
        return $this->hasOne(Unidad::className(), ['id' => 'unidad_id']);
    }
}
