<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\models\Personal as ModelsPersonal;
use app\models\Unidad as ModelsUnidad;
use yii\helpers\ArrayHelper;
use yii\jui\DatePicker;

$estados = Array(0 => "Inactivo", 1 => "Activo",);

/* @var $this yii\web\View */
/* @var $model app\models\Asistencia */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="asistencia-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'personal_id')->dropDownList(ArrayHelper::map(ModelsPersonal::find()->all(), 'id', 'app')) ?>
    
    <?= $form->field($model, 'unidad_id')->dropDownList(ArrayHelper::map(ModelsUnidad::find()->all(), 'id', 'nombre')) ?>

    <?= $form->field($model, 'entrada')->widget(DatePicker::classname(), [
        //'language' => 'ru',
        'options' => ['class' => 'form-control'],
        'dateFormat' => 'yyyy-MM-dd',
    ]) ?>

    <?= $form->field($model, 'horaentrada')->textInput() ?>

    <?= $form->field($model, 'salida')->widget(DatePicker::classname(), [
        //'language' => 'ru',
        'options' => ['class' => 'form-control'],
        'dateFormat' => 'yyyy-MM-dd',
    ]) ?>

    <?= $form->field($model, 'horasalida')->textInput() ?>

    <?= $form->field($model, 'horas')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'estado')->dropDownList($estados) ?>

    <div class="form-group">
        <?= Html::submitButton('Grabar', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
