<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $searchModel app\models\AsistenciaSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Asistencias';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="asistencia-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Crear Asistencia', ['create'], ['class' => 'btn btn-success']) ?>
        <?= Html::a('Reporte', ['pdf'], ['class' => 'btn btn-danger']) ?>
    </p>

    <?php Pjax::begin(); ?>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            //'personal_id',
            [
                'attribute' => 'personal_id',
                'value' => 'personal.app',
            ],
            //'unidad_id',
            [
                'attribute' => 'unidad_id',
                'value' => 'unidad.nombre',
            ],
            'entrada',
            'horaentrada',
            //'salida',
            //'horasalida',
            //'horas',
            //'estado',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, \app\models\Asistencia $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id, 'personal_id' => $model->personal_id]);
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
