<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\models\Personal as ModelsPersonal;
use app\models\Unidad as ModelsUnidad;
use yii\helpers\ArrayHelper;
use yii\jui\DatePicker;
//use kartik\time\TimePicker;

$estados = Array(0 => "Inactivo", 1 => "Activo",);

/* @var $this yii\web\View */
/* @var $model app\models\Horario */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="horario-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'personal_id')->dropDownList(ArrayHelper::map(ModelsPersonal::find()->all(), 'id', 'nombre')) ?>
    
    <?= $form->field($model, 'unidad_id')->dropDownList(ArrayHelper::map(ModelsUnidad::find()->all(), 'id', 'nombre')) ?>

    <?= $form->field($model, 'fechaini')->widget(DatePicker::classname(), [
        //'language' => 'ru',
        'options' => ['class' => 'form-control'],
        'dateFormat' => 'yyyy-MM-dd',
    ]) ?>

    <?= $form->field($model, 'horaentrada')->textInput() ?>

    <?= $form->field($model, 'fechafin')->widget(DatePicker::classname(), [
        //'language' => 'ru',
        'options' => ['class' => 'form-control'],
        'dateFormat' => 'yyyy-MM-dd',
    ]) ?>

    <?= $form->field($model, 'horasalida')->textInput() ?>

    <?= $form->field($model, 'tipoturno')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'sit')->dropDownList($estados) ?>

    <div class="form-group">
        <?= Html::submitButton('Grabar', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
