<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $searchModel app\models\HorarioSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Horarios';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="horario-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Crear Horario', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php Pjax::begin(); ?>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            //'personal_id',
            [
                'attribute' => 'personal_id',
                'value' => 'personal.app',
            ],
            //'unidad_id',
            [
                'attribute' => 'unidad_id',
                'value' => 'unidad.nombre',
            ],
            'fechaini',
            'horaentrada',
            //'fechafin',
            //'horasalida',
            //'tipoturno',
            //'sit',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, \app\models\Horario $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id, 'personal_id' => $model->personal_id, 'unidad_id' => $model->unidad_id]);
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
