<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $searchModel app\models\UnidadSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Unidades';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="unidad-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Crear Unidad', ['create'], ['class' => 'btn btn-success']) ?>
        <?= Html::a('Reporte', ['pdf'], ['class' => 'btn btn-danger']) ?>
    </p>

    <?php Pjax::begin(); ?>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'nombre',
            'direccion',
            //'cliente_id',
            [
                'attribute' => 'cliente_id',
                'value' => 'cliente.nombre',
            ],
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, \app\models\Unidad $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id, 'cliente_id' => $model->cliente_id]);
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
