<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "asistencia".
 *
 * @property int $id
 * @property int $personal_id
 * @property int $unidad_id
 * @property int $unidad_cliente_id
 * @property string|null $entrada
 * @property string|null $horaentrada
 * @property string|null $salida
 * @property string|null $horasalida
 * @property float|null $horas
 * @property string|null $estado
 *
 * @property Personal $personal
 * @property Unidad $unidad
 */
class Asistencia extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'asistencia';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['personal_id', 'unidad_id', 'unidad_cliente_id'], 'required'],
            [['personal_id', 'unidad_id', 'unidad_cliente_id'], 'integer'],
            [['entrada', 'salida'], 'safe'],
            [['horas'], 'number'],
            [['horaentrada', 'horasalida', 'estado'], 'string', 'max' => 45],
            [['personal_id'], 'exist', 'skipOnError' => true, 'targetClass' => Personal::className(), 'targetAttribute' => ['personal_id' => 'id']],
            [['unidad_id', 'unidad_cliente_id'], 'exist', 'skipOnError' => true, 'targetClass' => Unidad::className(), 'targetAttribute' => ['unidad_id' => 'id', 'unidad_cliente_id' => 'cliente_id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'personal_id' => 'Personal ID',
            'unidad_id' => 'Unidad ID',
            'unidad_cliente_id' => 'Unidad Cliente ID',
            'entrada' => 'Entrada',
            'horaentrada' => 'Horaentrada',
            'salida' => 'Salida',
            'horasalida' => 'Horasalida',
            'horas' => 'Horas',
            'estado' => 'Estado',
        ];
    }

    /**
     * Gets query for [[Personal]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPersonal()
    {
        return $this->hasOne(Personal::className(), ['id' => 'personal_id']);
    }

    /**
     * Gets query for [[Unidad]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUnidad()
    {
        return $this->hasOne(Unidad::className(), ['id' => 'unidad_id', 'cliente_id' => 'unidad_cliente_id']);
    }
}
