<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Asistencia;

/**
 * AsistenciaSearch represents the model behind the search form of `app\models\Asistencia`.
 */
class AsistenciaSearch extends Asistencia
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'personal_id', 'unidad_id', 'unidad_cliente_id'], 'integer'],
            [['entrada', 'horaentrada', 'salida', 'horasalida', 'estado'], 'safe'],
            [['horas'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Asistencia::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'personal_id' => $this->personal_id,
            'unidad_id' => $this->unidad_id,
            'unidad_cliente_id' => $this->unidad_cliente_id,
            'entrada' => $this->entrada,
            'salida' => $this->salida,
            'horas' => $this->horas,
        ]);

        $query->andFilterWhere(['like', 'horaentrada', $this->horaentrada])
            ->andFilterWhere(['like', 'horasalida', $this->horasalida])
            ->andFilterWhere(['like', 'estado', $this->estado]);

        return $dataProvider;
    }
}
