<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "cliente".
 *
 * @property int $id
 * @property string|null $nombre
 * @property string|null $direccion
 * @property string|null $email
 * @property string|null $fono
 * @property string|null $encargado
 *
 * @property Unidad[] $unidads
 */
class Cliente extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'cliente';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre', 'email', 'fono'], 'string', 'max' => 45],
            [['direccion'], 'string', 'max' => 100],
            [['encargado'], 'string', 'max' => 150],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nombre' => 'Nombre',
            'direccion' => 'Direccion',
            'email' => 'Email',
            'fono' => 'Fono',
            'encargado' => 'Encargado',
        ];
    }

    /**
     * Gets query for [[Unidads]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUnidads()
    {
        return $this->hasMany(Unidad::className(), ['cliente_id' => 'id']);
    }
}
