<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "horario".
 *
 * @property int $id
 * @property int $personal_id
 * @property int $unidad_id
 * @property int $unidad_cliente_id
 * @property string|null $fechaini
 * @property string|null $fechafin
 * @property string|null $tipoturno
 * @property int|null $sit
 * @property string|null $horaentrada
 * @property string|null $horasalida
 *
 * @property Personal $personal
 * @property Unidad $unidad
 */
class Horario extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'horario';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['personal_id', 'unidad_id', 'unidad_cliente_id'], 'required'],
            [['personal_id', 'unidad_id', 'unidad_cliente_id', 'sit'], 'integer'],
            [['fechaini', 'fechafin'], 'safe'],
            [['tipoturno', 'horaentrada', 'horasalida'], 'string', 'max' => 45],
            [['personal_id'], 'exist', 'skipOnError' => true, 'targetClass' => Personal::className(), 'targetAttribute' => ['personal_id' => 'id']],
            [['unidad_id', 'unidad_cliente_id'], 'exist', 'skipOnError' => true, 'targetClass' => Unidad::className(), 'targetAttribute' => ['unidad_id' => 'id', 'unidad_cliente_id' => 'cliente_id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'personal_id' => 'Personal ID',
            'unidad_id' => 'Unidad ID',
            'unidad_cliente_id' => 'Unidad Cliente ID',
            'fechaini' => 'Fechaini',
            'fechafin' => 'Fechafin',
            'tipoturno' => 'Tipoturno',
            'sit' => 'Sit',
            'horaentrada' => 'Horaentrada',
            'horasalida' => 'Horasalida',
        ];
    }

    /**
     * Gets query for [[Personal]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPersonal()
    {
        return $this->hasOne(Personal::className(), ['id' => 'personal_id']);
    }

    /**
     * Gets query for [[Unidad]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUnidad()
    {
        return $this->hasOne(Unidad::className(), ['id' => 'unidad_id', 'cliente_id' => 'unidad_cliente_id']);
    }
}
