<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "personal".
 *
 * @property int $id
 * @property string|null $nombre
 * @property string|null $app
 * @property string|null $apm
 * @property string|null $dob
 * @property string|null $direccion
 * @property string|null $rut
 * @property string|null $estcivil
 * @property string|null $ciunac
 * @property string|null $nacionalidad
 * @property string|null $sissalud
 * @property string|null $afp
 * @property string|null $fonoper
 * @property string|null $fonocontacto
 * @property string|null $instalación
 * @property string|null $hijos
 * @property string|null $certos10
 * @property int|null $sit
 *
 * @property Asistencia[] $asistencias
 * @property Horario[] $horarios
 */
class Personal extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'personal';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['dob'], 'safe'],
            [['sit'], 'integer'],
            [['nombre', 'app', 'apm'], 'string', 'max' => 100],
            [['direccion'], 'string', 'max' => 255],
            [['rut', 'estcivil', 'ciunac', 'nacionalidad', 'sissalud', 'afp', 'fonoper', 'fonocontacto', 'instalación', 'hijos', 'certos10'], 'string', 'max' => 45],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nombre' => 'Nombre',
            'app' => 'App',
            'apm' => 'Apm',
            'dob' => 'Dob',
            'direccion' => 'Direccion',
            'rut' => 'Rut',
            'estcivil' => 'Estcivil',
            'ciunac' => 'Ciunac',
            'nacionalidad' => 'Nacionalidad',
            'sissalud' => 'Sissalud',
            'afp' => 'Afp',
            'fonoper' => 'Fonoper',
            'fonocontacto' => 'Fonocontacto',
            'instalación' => 'Instalación',
            'hijos' => 'Hijos',
            'certos10' => 'certos10',
            'sit' => 'Sit',
        ];
    }

    /**
     * Gets query for [[Asistencias]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAsistencias()
    {
        return $this->hasMany(Asistencia::className(), ['personal_id' => 'id']);
    }

    /**
     * Gets query for [[Horarios]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getHorarios()
    {
        return $this->hasMany(Horario::className(), ['personal_id' => 'id']);
    }
}
