<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Personal;

/**
 * PersonalSearch represents the model behind the search form of `app\models\Personal`.
 */
class PersonalSearch extends Personal
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'sit'], 'integer'],
            [['nombre', 'app', 'apm', 'dob', 'direccion', 'rut', 'estcivil', 'ciunac', 'nacionalidad', 'sissalud', 'afp', 'fonoper', 'fonocontacto', 'instalación', 'hijos', 'certos10'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Personal::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'dob' => $this->dob,
            'sit' => $this->sit,
        ]);

        $query->andFilterWhere(['like', 'nombre', $this->nombre])
            ->andFilterWhere(['like', 'app', $this->app])
            ->andFilterWhere(['like', 'apm', $this->apm])
            ->andFilterWhere(['like', 'direccion', $this->direccion])
            ->andFilterWhere(['like', 'rut', $this->rut])
            ->andFilterWhere(['like', 'estcivil', $this->estcivil])
            ->andFilterWhere(['like', 'ciunac', $this->ciunac])
            ->andFilterWhere(['like', 'nacionalidad', $this->nacionalidad])
            ->andFilterWhere(['like', 'sissalud', $this->sissalud])
            ->andFilterWhere(['like', 'afp', $this->afp])
            ->andFilterWhere(['like', 'fonoper', $this->fonoper])
            ->andFilterWhere(['like', 'fonocontacto', $this->fonocontacto])
            ->andFilterWhere(['like', 'instalación', $this->instalación])
            ->andFilterWhere(['like', 'hijos', $this->hijos])
            ->andFilterWhere(['like', 'certos10', $this->certos10]);

        return $dataProvider;
    }
}
