<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\Horario */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Horarios', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="horario-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id, 'personal_id' => $model->personal_id, 'unidad_id' => $model->unidad_id, 'unidad_cliente_id' => $model->unidad_cliente_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id, 'personal_id' => $model->personal_id, 'unidad_id' => $model->unidad_id, 'unidad_cliente_id' => $model->unidad_cliente_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'personal_id',
            'unidad_id',
            'unidad_cliente_id',
            'fechaini',
            'fechafin',
            'tipoturno',
            'sit',
            'horaentrada',
            'horasalida',
        ],
    ]) ?>

</div>
